// BasicUSB_6124.cpp : Defines the entry point for the console application.
//
#include <windows.h>
#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <process.h>
#include "USBLibrary.h"

typedef struct _DEVICE {
	char *name;
	unsigned int number;
	unsigned int txrate;
	struct _DEVICE *next;
	char active;
} *PDEVICE, DEVICE;

PDEVICE listOfDevice = (PDEVICE) 0;

unsigned int deviceNumber = 0;
HANDLE threadMutex;

//*----------------------------------------------------------------------------
//* \fn    GenerateBuffer
//* \brief 
//*----------------------------------------------------------------------------
int GenerateBuffer(char *buff, unsigned int maxLength)
{
	unsigned int length = 0;

	while (!length || !(length % 64)) {
		length = rand() % maxLength;
		for (unsigned int i = 0; i < length; ++i)
			buff[i] = rand() % 0xFF;
	}

	return length;
}

//*----------------------------------------------------------------------------
//* \fn    DeviceThread
//* \brief 
//*----------------------------------------------------------------------------
#define MSG_SIZE 1000
void DeviceThread(void *pVoidDevice)
{
	PDEVICE pDevice = (PDEVICE) pVoidDevice;
	CFCPipeUSB pipe;
	char txMsg[MSG_SIZE], rxMsg[MSG_SIZE];
	unsigned long  msgLength, msgWritten;

	// open the device
	if (pipe.Open(pDevice->name))
		printf("-E- Can not open device %d\n%s\n", pDevice->number, pDevice->name);
	printf("-I- New device connected %d \n", pDevice->number); 
	
	while (1) {
		msgLength = GenerateBuffer(txMsg, MSG_SIZE);
		if (pipe.WritePipe(txMsg, msgLength, &msgWritten) || (msgLength != msgWritten)) {
			printf("-E- Write operation to device %d failed\n", pDevice->number);
			break;
		}
		if (pipe.ReadPipe (rxMsg, msgLength)) {
			printf("-E- Read operation to device %d failed\n", pDevice->number);
			break;
		}
		if (memcmp(txMsg, rxMsg, msgLength))
			printf("-E- Device %d Message received & transmitted are different\n");

		WaitForSingleObject( threadMutex, INFINITE );
		pDevice->txrate += msgLength;
		ReleaseMutex( threadMutex );

		Sleep(1000L);
	}

	// close handle
	pipe.Close();
	printf("-I- Device %d not responding: closed\n", pDevice->number); 


	// Unlink from the the deviceList

	WaitForSingleObject( threadMutex, INFINITE );
	pDevice->active = 'N';
	ReleaseMutex( threadMutex );

	_endthread();
}

//*----------------------------------------------------------------------------
//* \fn    DllMain
//* \brief 
//*----------------------------------------------------------------------------
int main(int argc, char* argv[])
{
	unsigned int nbConnectedDevices, nbActiveDevice, i;
	char ** strConnectedDevices;
	PDEVICE ptDevice;

	threadMutex = CreateMutex( NULL, FALSE, NULL );   /* Cleared */

	printf("==========================================================\n");
	printf("=======    ATMEL USB Basic Application             =======\n");
	printf("==========================================================\n");

	do
    {
		// Get all device names
 		nbConnectedDevices = GetUsbDeviceListName(&strConnectedDevices);
		for ( i = 0; i < nbConnectedDevices; ++i) {

			// Search if the device has been detected
			for (ptDevice = listOfDevice; ptDevice; ptDevice = ptDevice->next) {
				if (!strcmp(ptDevice->name, strConnectedDevices[i])) {
					WaitForSingleObject( threadMutex, INFINITE );
					// If the device has been stoppped, restart it
					if (ptDevice->active == 'N') {
						ptDevice->active = 'Y';
						_beginthread( DeviceThread, 0, ptDevice );
					}
					ReleaseMutex( threadMutex );
					break;
				}
			}

			// If the device has not been registered, register it and create a new task
			if (!ptDevice) {
				ptDevice = (PDEVICE) malloc(sizeof(DEVICE));
				ptDevice->name = _strdup(strConnectedDevices[i]);
				ptDevice->txrate = 0;
				ptDevice->number = deviceNumber++;
				ptDevice->next = listOfDevice;

				WaitForSingleObject( threadMutex, INFINITE );
				ptDevice->active = 'Y';
				ReleaseMutex( threadMutex );

				listOfDevice = ptDevice;

				printf("-I- Add device %d\n", deviceNumber, ptDevice);
				_beginthread( DeviceThread, 0, ptDevice );
			}

		}

/*		// Delete name list returned by GetUsbDeviceListName
		if (nbConnectedDevices != 0) {
				for ( i = 0; i < nbConnectedDevices; ++i)
					free(strConnectedDevices[i]);
			free(strConnectedDevices);
		}
*/
 		Sleep(2000L); // Sleep 2s

		// Print statistics
		WaitForSingleObject( threadMutex, INFINITE );
		nbActiveDevice = 0;
		printf("==========================================================\n");
		for (ptDevice = listOfDevice; ptDevice; ptDevice = ptDevice->next) {
			printf("\t Device %02d  Transfered %d Bytes/s Active: %c\n", ptDevice->number, ptDevice->txrate, ptDevice->active);
			if (ptDevice->active == 'Y')
				++nbActiveDevice;
		}
		ReleaseMutex( threadMutex );

    } while( nbActiveDevice );
	printf("-I- No device connected\n");

	return 1;
}
	
